VERSION 5.00
Begin VB.Form capdly_projDet 
   Caption         =   "Form1"
   ClientHeight    =   7785
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   10155
   LinkTopic       =   "Form1"
   MinButton       =   0   'False
   ScaleHeight     =   7785
   ScaleWidth      =   10155
   Tag             =   "form_DetailProject"
   Begin VB.Frame frm_projectDetail 
      Caption         =   "#Project report detail ..."
      Height          =   7005
      Left            =   15
      TabIndex        =   0
      Tag             =   "frm_projectDetail"
      Top             =   810
      Width           =   10125
      Begin VB.Frame frm_grouping 
         Caption         =   "#Grouping"
         Height          =   600
         Left            =   165
         TabIndex        =   3
         Tag             =   "frm_grouping"
         Top             =   270
         Width           =   9405
         Begin VB.CheckBox chk_country 
            Caption         =   "#Country"
            Height          =   240
            Left            =   135
            TabIndex        =   5
            Tag             =   "chk_country"
            Top             =   285
            Width           =   2325
         End
         Begin VB.CheckBox chk_salesRep 
            Caption         =   "#Sales rep."
            Height          =   240
            Left            =   2520
            TabIndex        =   4
            Tag             =   "chk_salesRep"
            Top             =   270
            Width           =   2325
         End
      End
      Begin VB.Frame frm_projectDetailCalc 
         Height          =   1995
         Left            =   255
         TabIndex        =   1
         Tag             =   "frm_projectDetailCalc"
         Top             =   1950
         Visible         =   0   'False
         Width           =   9165
         Begin VB.Label lbl_projectDetailCalculation 
            Alignment       =   2  'Center
            Caption         =   "#caption calculate projects"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   12
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   1215
            Left            =   150
            TabIndex        =   2
            Tag             =   "lbl_projectDetCal"
            Top             =   300
            Width           =   8880
         End
      End
      Begin Project1.ArmGrid grd_list 
         Height          =   5580
         Left            =   120
         TabIndex        =   6
         Tag             =   "grd_projectDetail"
         Top             =   915
         Width           =   9495
         _ExtentX        =   16748
         _ExtentY        =   5662
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Align           =   1  'Align Top
      Height          =   690
      Left            =   0
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   0
      Width           =   10155
      _ExtentX        =   17912
      _ExtentY        =   1217
   End
End
Attribute VB_Name = "capdly_projDet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Option Compare Text

'what is new
'2.7.1 bugfix - support for treeview market-area (JN)
'2.7.1 support for treeview market-customer (JN)



'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK API FUNCTION DECLARES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function GetSystemDefaultLCID Lib "kernel32" () As Long

Private Const COLOR_BLUE  As Long = &HFF0000
Private Const COLOR_GREY2 As Long = &HAAAAAA

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK VARIABLES
'**********************************************************************************************************************************
'**********************************************************************************************************************************
Private Enum ECapReportingTreeview
    creMarket = 1
    creArea = 2
    creMarketRep
End Enum

Public Event ReplacePlaceholders(ByRef as_str As String)


#If ENV = LIVE Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private ms_Language_Code                As String       'current user interface language
Private ml_U_code                       As Long         'U_Code (GEN_Systems_Users) of logged user
Private mb_InternalInit                 As Boolean      'framework is doing some own control manipulation, all events should handle

Private ms_TVFilterDesc As String
Private ms_SAFlagDesc As String
Private ms_PeriodDesc As String

Private ml_Year As Long
Private ml_Month As Long
Private mb_top10 As Boolean
Private ms_prjType As String
Private ml_cboTrw As Long
Private ms_period As String
Private ms_BMK_Code As String

Private ml_level_selected As Long

Private mb_fillGridOnStartup As Boolean

Private mc_ScreenLabels As Long

Private mb_Initialized                  As Boolean      'framework is initialised or not

Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME       As String = "Capture_Rrpt_PrjDetail"
Private ms_DecimalSeparator             As String       'locale decimal separator
Private ms_ThousandSeparator            As String       'locale thousand separator

Private Const SW_SHOWNORMAL = 1
Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CUSTOM METHODS
' Change content of methods as you need, but do not add any new method or property here !
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Function Load_A_COM_Custom() As Boolean
On Error GoTo ErrHandler
    
    Load_A_COM_Custom = True
    Exit Function
ErrHandler:
    Call ErrorHandler("Load_A_COM_Custom")
End Function

Private Sub UnLoad_A_COM_Custom()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorHandler("UnLoad_A_COM_Custom")
End Sub

Public Function Run(ByVal al_cboTrw As Long, ByVal as_prjType As String, ByVal al_Month As Long, ByVal al_Year As Long, ByVal ab_top10 As Boolean, ByVal as_BMK_Code As String, as_period As String) As Boolean
On Error GoTo ErrorHandler
    Run = False
    
    ml_Year = al_Year
    ml_Month = al_Month
    mb_top10 = ab_top10
    ms_prjType = as_prjType
    ml_cboTrw = al_cboTrw
    ms_period = as_period
    ms_BMK_Code = as_BMK_Code
    
    ' init screen controls
    Call tlb_main.DisplayFace("0")
    ' according level/type of treeview display possible groupping
    If ml_level_selected <= 1 Then
        If al_cboTrw <> ECapReportingTreeview.creArea Then
            chk_country.Enabled = True
            chk_salesRep.value = vbUnchecked
        Else
            chk_country.Enabled = False
            chk_salesRep.value = vbChecked
        End If
        chk_country.value = vbUnchecked
    Else
        chk_country.Enabled = False
        chk_country.value = vbChecked
        chk_salesRep.value = vbChecked
        mb_fillGridOnStartup = True
    End If
    
    ' hide the grid
    grd_list.Visible = False
    
    ' show detail frame
    frm_projectDetail.Caption = ""
    
    Call DefineProjectGrid(grd_list, as_prjType, as_period)
    
    ' display form
    Me.show 1
    
    Run = True
    Exit Function
ErrorHandler:
    Call ErrorMessage("Run")
End Function

Private Sub Init_Custom()
On Error GoTo ErrHandler
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 2442, 2830, $id$"
Const TLB_DETAIL_ID As Long = 2857

    'Initialization of the component of the form
    ' toolbar init
    ' main toolbar
    Dim ll_Cursor  As Long
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_Cursor, "id", TLB_DETAIL_ID) >= 0 Then
        Call tlb_main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_Cursor, "info"), Left(mo_Db.GetFields(ll_Cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_DETAIL_ID & ") not found in DB")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    
    grd_list.ExportTitles = True
    grd_list.AllowExcelExport = True
    grd_list.FetchAll = True
    grd_list.AllowSort = False

    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then Call mo_Db.Close(ll_Cursor)
    Call ErrorHandler("Init_Custom")
End Sub

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK PROPERTIES
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Property Let TVFilterDesc(ByVal as_TVDest As String)
    ms_TVFilterDesc = as_TVDest
End Property

Public Property Let SP_SAFlagDesc(ByVal as_SAFlagDesc As String)
    ms_SAFlagDesc = as_SAFlagDesc
End Property

Public Property Let PeriodDesc(ByVal as_PeriodDesc As String)
    ms_PeriodDesc = as_PeriodDesc
End Property

Public Property Let Level_selected(ByVal al_level_selected As Long)
    ml_level_selected = al_level_selected
End Property

Public Property Let ScreenLabels(ByVal lc_ScreenLabels As Long)
    mc_ScreenLabels = lc_ScreenLabels
End Property

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property


Property Let U_Code(al_Code As Long)
ml_U_code = al_Code
End Property

Property Let Language_Code(AString As String)
ms_Language_Code = AString
End Property

Public Property Set ArmDb(ByRef local_connection As Object)
    If Not (local_connection Is Nothing) Then
        Set mo_Db = local_connection
    End If
End Property


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK METHODS
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Function Load_A_Com() As Boolean

Dim ll_Index As Long
Dim lo_Control As Object

On Error GoTo ErrHandler
    
    Load_A_Com = False
    
    If mb_Initialized Then
        Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    End If
    
    mb_InternalInit = False
    ms_DecimalSeparator = Format(0, ".")
    mb_fillGridOnStartup = False
    
    ReDim mt_MainConfig(-1 To -1)
    ReDim mt_DetailConfig(-1 To -1)
    ReDim mt_SubdetailConfig(-1 To -1)
    
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If
    
    For Each lo_Control In Me.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.Load_A_Com
        Case "TOOLBR"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    Call Form_Resize
    mb_Initialized = Load_A_COM_Custom
    Load_A_Com = mb_Initialized
    Exit Function
ErrHandler:
    Load_A_Com = False
    Call ErrorMessage("Load_A_COM")
End Function

Public Function Unload_A_Com() As Boolean
    
On Error GoTo ErrHandler
    
    Dim lo_Control As Object
    Dim ll_Index As Long
    
    Call UnLoad_A_COM_Custom
    
    For Each lo_Control In Me.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER"
            Call lo_Control.Unload_A_Com
        End Select
    Next
    
    Set mo_Db = Nothing
    mb_Initialized = False
    Unload_A_Com = True
    Exit Function
ErrHandler:
    Unload_A_Com = False
    Call ErrorMessage("Unload_A_Com")
End Function

Public Sub Resize()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorMessage("Resize")
End Sub

Public Function Init_control() As Boolean
Dim ll_Index As Long

On Error GoTo ErrHandler

    Call Init_Custom
    
    Call ChangeCharset(Me.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    Call LoadLabels(mo_Db, Me, mc_ScreenLabels)
    
    Init_control = True
    Exit Function
ErrHandler:
    Init_control = False
    Call ErrorMessage("Init_control")
End Function

Private Function HasContainer(ByVal lo_Control As Control, ByRef lo_Container As Object) As Boolean
    Dim ll_Index As Long
    Dim lo_Object As Object

    On Error GoTo CleanUp   'not all controls support Container property
    HasContainer = False
    While Not (lo_Control Is Nothing)
        If lo_Control.Container Is lo_Container Then
            HasContainer = True
            Exit Function
        End If
        Set lo_Control = lo_Control.Container
    Wend

CleanUp:

End Function

Private Sub ResetFrameControls(ByRef ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control

    mb_InternalInit = True
    For Each lo_Control In Me.Controls
    
        If HasContainer(lo_Control, ao_Frame) Then
            Select Case UCase(TypeName(lo_Control))
                Case "ARMCOMBOBOX"
                    Call lo_Control.Clear
                    lo_Control.Tag = ""
                    lo_Control.Request = ""
                    lo_Control.Visible = False
                Case "ARMPICKER"
                    Call lo_Control.Clear
                    lo_Control.Tag = ""
                    lo_Control.Visible = False
                Case "CHECKBOX"
                    lo_Control.value = Unchecked
                    lo_Control.Tag = ""
                    lo_Control.Caption = ""
                    lo_Control.Visible = False
                Case "TEXTBOX"
                    lo_Control.Tag = ""
                    lo_Control.Text = ""
                    lo_Control.Visible = False
                Case "A_CALOCX"
                    Call lo_Control.reinit_cal
                    lo_Control.Tag = ""
                    lo_Control.Visible = False
                Case "LABEL"
                    lo_Control.Tag = ""
                    lo_Control.Caption = ""
                    lo_Control.FontBold = False
                    lo_Control.Visible = False
            End Select
        End If
    Next
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("ResetFrameControls")
End Sub

' ************************************************************************************
' FRAMEWORK DB-ACCESS FUNCTIONS
' please do not change this code
' ************************************************************************************

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If ENV = LIVE Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If ENV = LIVE Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    Call LogMessage(SCREEN_NAME & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
    Dim ll_errNumber As Long
    Dim ls_ErrDescription As String, ls_ErrSource As String
    
    ll_errNumber = Err.Number
    ls_ErrDescription = Err.Description
    ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ls_Source As String, ls_Msg As String
    
    ls_Source = SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    ls_Msg = as_logMsg & SEP1 & ll_errNumber & " : " & ls_ErrDescription & " - " & ls_ErrSource
    
    ls_req = ReplacePlaceHolder(LOG_REQUEST, "$UCODE$", CStr(ml_U_code))
    ls_req = ReplacePlaceHolder(ls_req, "$LOGTYPE$", SQLStr(as_logType))
    ls_req = ReplacePlaceHolder(ls_req, "$MSG$", Left(Trim(SQLStr(ls_Msg)), 4000))
    ls_req = ReplacePlaceHolder(ls_req, "$APP$", Left(Trim(SQLStr(ls_Source)), 50))
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
    Exit Sub
    
ErrHandler:
    If ab_ExitOnException Then
        Call MsgBox("A fatal error occured. Unable to log error into database, the application will be close. Please report the following message to your IT support: " & vbCrLf & _
            "Number:" & Err.Number & vbCrLf & "Description:" & Err.Description, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
        End
    End If
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
End Sub

Private Function SQLStr(ByVal as_Data As String) As String
On Error GoTo ErrHandler

    SQLStr = "'" & Replace(as_Data, "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlStr")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    as_Request = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)
    
    ReplacePlaceHolder = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholder")
End Function

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        Me.Enabled = False
        LockWindowUpdate Me.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        Me.Enabled = True
        Me.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub


' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ll_codePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_Cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_Cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call ao_Armdb.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)

On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0", "ARMPICKER"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ChangeCharset")
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef ao_Armdb As ArmDb, ByRef ao_Container As Object, ByVal lc_Labels As Long)
Dim lo_Control As Control   ' A control of the container
Dim li_Idx As Integer, li_Count As Integer
Dim li_Label As Integer      ' A label idx
Dim lsa_ControlTag() As String
    
    On Error GoTo Trace_Err

    On Error GoTo WithoutTag
    If ao_Container.Tag <> "" Then
        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", Me.Tag, , 1)
        If li_Label >= 0 Then
            Me.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
        End If
    End If
WithoutTag:
    
    On Error GoTo Trace_Err
    
    ' Iterate the container for loading the label of each element which has defined a tag
    For Each lo_Control In Me.Controls
        
        If HasContainer(lo_Control, ao_Container) Or _
          ((ao_Container Is Me) And (UCase(TypeName(lo_Control)) = "MENU")) Then
            Select Case UCase(TypeName(lo_Control))
                Case UCase("TabStrip") ' Component is a tabstrip, we load the caption of each tab defined
                    Dim lo_Tbs
                    Set lo_Tbs = lo_Control ' Cast for use of intellisense
                    li_Count = lo_Tbs.Tabs.Count
                    For li_Idx = 1 To li_Count
                        If lo_Tbs.Tabs(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Tbs.Tabs(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_Tbs.Tabs(li_Idx).Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_Tbs = Nothing
                
                Case UCase("ListView") ' Component is a listview, we load the caption of each columns
                    Dim lo_ListView As ListView
                    Set lo_ListView = lo_Control
                    li_Count = lo_ListView.ColumnHeaders.Count
                    For li_Idx = 1 To li_Count
                        If lo_ListView.ColumnHeaders(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_ListView.ColumnHeaders(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_ListView.ColumnHeaders(li_Idx).Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_ListView = Nothing
            
                Case UCase("TextBox")  ' Component is a textbox
                    Dim lo_TextBox As TextBox
                    Set lo_TextBox = lo_Control
                    If lo_TextBox.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_TextBox.Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                    Set lo_TextBox = Nothing
                
                Case UCase("Label"), UCase("Frame"), UCase("CommandButton"), UCase("CheckBox"), UCase("OptionButton")
                    If lo_Control.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Case UCase("ArmGrid")
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                    If li_Label >= 0 Then
                      Call lo_Control.LoadConstants(ptStatic, ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT"), ctColumns)
                    End If
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag & "_Title", , 1)
                    If li_Label >= 0 Then
                      lo_Control.Title = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                Case UCase("Menu")
                    If lo_Control.Tag <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
            End Select
        End If
    Next
    
Trace_End:
    Exit Sub
    
Trace_Err:
      
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.", vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    MsgText = aDefault
End Function


Private Sub Form_Resize()
    frm_projectDetail.Top = tlb_main.Top + tlb_main.Height
    frm_projectDetail.Width = Me.Width - 120
    If Me.Height - (tlb_main.Top + tlb_main.Height) > 600 Then
        frm_projectDetail.Height = Me.Height - (tlb_main.Top + tlb_main.Height) - 430
    Else
        frm_projectDetail.Height = 200
    End If
    
    frm_grouping.Left = 60
    frm_grouping.Top = 260
    If frm_projectDetail.Width > 520 Then
        frm_grouping.Width = frm_projectDetail.Width - 120
    Else
        frm_grouping.Width = 520
    End If
        
    
    grd_list.Left = frm_grouping.Left
    grd_list.Top = frm_grouping.Top + frm_grouping.Height
    grd_list.Width = frm_grouping.Width
    If frm_projectDetail.Height - (frm_grouping.Top + frm_grouping.Height) > 100 Then
        grd_list.Height = frm_projectDetail.Height - (frm_grouping.Top + frm_grouping.Height) - 60
    Else
        grd_list.Height = 100
    End If
    
    frm_projectDetailCalc.Left = frm_grouping.Left
    frm_projectDetailCalc.Width = frm_grouping.Width
    lbl_projectDetailCalculation.Left = 60
    lbl_projectDetailCalculation.Width = frm_projectDetailCalc.Width - 120
'    tlb_main.Redraw
    If mb_fillGridOnStartup Then
        mb_fillGridOnStartup = False
        Call Process_ProjectDetail(ml_Year, ml_Month, mb_top10, ms_prjType, ml_cboTrw, ms_period)
    End If
End Sub

Private Sub Process_ProjectDetail(ByVal al_Year As Long, ByVal al_Month As Long, ByVal ab_top10 As Boolean, ByVal as_prjType As String, ByVal al_TVFilterCode As Long, ByVal as_period As String)
On Error GoTo ErrorHandler
    Dim ls_req As String

    grd_list.Visible = False
    
    ReDim ms_MsgInfo(3, 1)
    ms_MsgInfo(0, 0) = "$TV1$"
    ms_MsgInfo(0, 1) = ms_TVFilterDesc
    ms_MsgInfo(1, 0) = "$MONTH$"
    ms_MsgInfo(1, 1) = al_Month & "/" & al_Year
    ms_MsgInfo(2, 0) = "$TOP10$"
    If ab_top10 Then
        ms_MsgInfo(2, 1) = GetLabel("TOP10", "#Top 10")
    Else
        ms_MsgInfo(2, 1) = GetLabel("OTHER", "#Other")
    End If
    ms_MsgInfo(3, 0) = "$PERIOD$"
    ms_MsgInfo(3, 1) = ms_PeriodDesc
    
    frm_projectDetail.Visible = True
    frm_projectDetail.Caption = GetLabel(frm_projectDetail.Tag, "#Projects $TV1$  $PERIOD$: $MONTH$ ($TOP10$)", ms_MsgInfo)

    Call grd_list.ClearGrid
    frm_projectDetailCalc.Visible = True
    
    lbl_projectDetailCalculation.Caption = GetLabel(lbl_projectDetailCalculation.Tag, "#Calculating Projects report ....")
    Call frm_projectDetail.Refresh
    DoEvents
    
    ls_req = GetProjectDetailRequest(al_TVFilterCode, ml_level_selected, as_period, as_prjType, IIf(chk_country.value = vbChecked, "Country", ""), IIf(chk_salesRep.value = vbChecked, "Creator", ""))
    
    If ls_req <> "" Then
        If ms_BMK_Code <> "" Then
            ls_req = Replace(ls_req, "$BMK_CODE$", ms_BMK_Code, , , vbTextCompare)
        End If
        RaiseEvent ReplacePlaceholders(ls_req)
        ls_req = Replace(ls_req, "$PYEAR$", al_Year)
        ls_req = Replace(ls_req, "$PMONTH$", al_Month)
        ls_req = Replace(ls_req, "$TOP10$", IIf(ab_top10, "Y", "N"))
        grd_list.Requests = ls_req
        If Not grd_list.Execute Then
            MsgBox "An error occured during this query, please take a screenshot and contact IT support"
        Else
            ' CALCULATE SUM for Top 10 and Other separatelly
            Dim lo_sumLine As New Dictionary
            
            Dim ll_i As Long
            For ll_i = 0 To grd_list.Cols - 1
                Call lo_sumLine.Add(grd_list.Columns(ll_i).Name, Empty)
            Next
            
            
            lo_sumLine("GRP_DESC") = GetLabel("s_total", "#TOTAL")
            
            For ll_i = 0 To grd_list.Rows - 1
'                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "REPLICS")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "STDProjects")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "SAProjects")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "ASProjects")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "Volume")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "SolutionLine")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "TotalPrdVol")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "ABPEPrdVol")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "ASPrdVol")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "SOMVol")
                Call GrdColumToSUMLine(grd_list, lo_sumLine, ll_i, "ProjectValue")
            Next ll_i

            Call grd_list.AddLine(lo_sumLine.Items())
            grd_list.LineColor(grd_list.Rows - 1) = COLOR_GREY2
            grd_list.TextColor(grd_list.Rows - 1) = COLOR_BLUE
        End If
        
        grd_list.Visible = True
        lbl_projectDetailCalculation.Caption = ""
        frm_projectDetailCalc.Visible = False
    End If

    grd_list.Visible = True
    
    Exit Sub
ErrorHandler:
    Call ErrorHandler(Me.Name & ".Process_ProjectDetail")
End Sub


Private Sub GrdColumToSUMLine(ByRef ao_grd As ArmGrid, ByRef ao_sumLine As Dictionary, ByVal al_Row As Long, ByVal as_colName As String)
On Error GoTo ErrorHandler
    If ao_sumLine.Exists(as_colName) Then
        ao_sumLine(as_colName) = ao_sumLine(as_colName) + ao_grd.Data(al_Row, as_colName)
    End If
    Exit Sub
ErrorHandler:
    Call ErrorHandler(Me.Name & ".GrdColumToSUMLine")
End Sub

Private Function GetLabel(ByVal as_Tag As String, ByVal as_DefaultValue As String, Optional ByVal aInfo As Variant) As String
    
    If mo_Db.Find(mc_ScreenLabels, "FIELD_NAME", as_Tag, , 1) >= 0 Then
        as_DefaultValue = mo_Db.GetFields(mc_ScreenLabels, "LOCAL_TEXT")
    End If
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            as_DefaultValue = Replace(as_DefaultValue, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    GetLabel = as_DefaultValue

End Function




Private Function GetProjectDetailRequest(ByVal al_trwCode As Long, ByVal al_Level As Long, ByVal as_period As String, ByVal as_prjType As String, ByVal as_Grp1 As String, ByVal as_Grp2 As String) As String
On Error GoTo ErrorHandler

    Dim ls_retVal As String
    Select Case al_trwCode
        Case 1  ' Market
            Select Case al_Level
                Case 0, 1 ' All markets / Market
                    ls_retVal = "EXEC Project$TYPE$_$PERIOD$Market$GRP1$$GRP2$ '$language_code$', $PYEAR$, $PMONTH$, '$TOP10$', '$BMK_Code$'"
                Case 2  ' Country
                    ls_retVal = "EXEC Project$TYPE$_$PERIOD$$GRP1$$GRP2$ '$language_code$', $PYEAR$, $PMONTH$, '$TOP10$', '$BMK_Code$', '$CT_Code$'"
                Case 3  ' User
                    ls_retVal = ""
            End Select
            
        Case 2  ' Area
            Select Case al_Level
                Case 0, 1 ' Area
                    ls_retVal = "EXEC Project$TYPE$_$PERIOD$RepGrp$GRP1$$GRP2$ '$language_code$', $PYEAR$, $PMONTH$, '$TOP10$', $RAR_Code$"
                Case 3  ' z_creator
                    ls_retVal = ""
            End Select
            
        Case 3
            Select Case al_Level
                Case 0, 1 ' All markets / Market
                    ls_retVal = "EXEC Project$TYPE$_$PERIOD$Market$GRP1$$GRP2$ '$language_code$', $PYEAR$, $PMONTH$, '$TOP10$', '$BMK_Code$'"
                Case 3  ' user
                    ls_retVal = ""
            End Select
        Case 4
            Select Case al_Level
                Case 0, 1 ' All markets / Market
                    ls_retVal = "EXEC Project$TYPE$_$PERIOD$Market$GRP1$$GRP2$ '$language_code$', $PYEAR$, $PMONTH$, '$TOP10$', '$BMK_Code$'"
                Case 3  ' user
                    ls_retVal = ""
            End Select
        Case 5
            Select Case al_Level
                Case 0, 1 ' All markets / Market
                    ls_retVal = "EXEC Project$TYPE$_$PERIOD$Market$GRP1$$GRP2$ '$language_code$', $PYEAR$, $PMONTH$, '$TOP10$', '$BMK_Code$'"
                Case 2  ' country
                    ls_retVal = "EXEC Project$TYPE$_$PERIOD$$GRP1$$GRP2$ '$language_code$', $PYEAR$, $PMONTH$, '$TOP10$', '$BMK_Code$', '$CT_Code$'"
                Case Else
                    ls_retVal = ""
            End Select
    End Select
    
    ' replace $TYPE$
    Select Case as_prjType
        Case "PRJ_ALL"
            ls_retVal = Replace(ls_retVal, "$TYPE$", "", , , vbTextCompare)
        Case "PRJ_STD"
            ls_retVal = Replace(ls_retVal, "$TYPE$", "STD", , , vbTextCompare)
        Case "PRJ_SA"
            ls_retVal = Replace(ls_retVal, "$TYPE$", "SA", , , vbTextCompare)
        Case "PRJ_AS"
            ls_retVal = Replace(ls_retVal, "$TYPE$", "AS", , , vbTextCompare)
    End Select
    
    'replace period
    Select Case as_period
        Case "MONTH"
            ls_retVal = Replace(ls_retVal, "$PERIOD$", "Month", , , vbTextCompare)
        Case "WEEK"
            ls_retVal = Replace(ls_retVal, "$PERIOD$", "Week", , , vbTextCompare)
    End Select

    'replace grouping
    ls_retVal = Replace(ls_retVal, "$GRP1$", as_Grp1, , , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$GRP2$", as_Grp2, , , vbTextCompare)


    GetProjectDetailRequest = ls_retVal

   Exit Function
    
ErrorHandler:
    Call ErrorHandler(Me.Name & ".GetProjectDetailRequest")
End Function

Private Sub DefineProjectGrid(ByRef ao_grid As ArmGrid, ByVal as_prjType As String, ByVal as_period As String)
On Error GoTo ErrorHandler

    If as_period = "MONTH" Then
        Select Case as_prjType
            Case "PRJ_ALL"
                ao_grid.Title = "#All Projects month view"
                
                ReDim la_Columns(11) As String
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "350" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "#Repl. days"
                la_Columns(2) = "STDProjects" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "STDProjects" & CH_LDELIMIT & "#STD Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "SAProjects" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SAProjects" & CH_LDELIMIT & "#SA Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(4) = "ASProjects" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASProjects" & CH_LDELIMIT & "#AS Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(5) = "Volume" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "#Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "SolutionLine" & CH_LDELIMIT & "450" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SolutionLine" & CH_LDELIMIT & "#Main solustion lines" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(7) = "TotalPrdVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(8) = "ABPEPrdVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(9) = "ASPrdVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(10) = "SOMVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SOMVol" & CH_LDELIMIT & "#Quoted vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(11) = "ProjectValue" & CH_LDELIMIT & "900" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ProjectValue" & CH_LDELIMIT & "#Quoted value (EUR)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                
            Case "PRJ_STD"
                ao_grid.Title = "#Std Projects month view"
                
                ReDim la_Columns(7) As String
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "#Repl. days"
                la_Columns(2) = "STDProjects" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "STDProjects" & CH_LDELIMIT & "#STD Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "Volume" & CH_LDELIMIT & "1200" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "#Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(4) = "SolutionLine" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SolutionLine" & CH_LDELIMIT & "#Main solustion lines" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(5) = "TotalPrdVol" & CH_LDELIMIT & "1300" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "ABPEPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(7) = "ASPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
            Case "PRJ_SA"
                ao_grid.Title = "#SA Projects month view"
                
                ReDim la_Columns(7) As String
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "#Repl. days"
                la_Columns(2) = "SAProjects" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SAProjects" & CH_LDELIMIT & "#SA Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "Volume" & CH_LDELIMIT & "1200" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "#Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(4) = "SolutionLine" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SolutionLine" & CH_LDELIMIT & "#Main solustion lines" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(5) = "TotalPrdVol" & CH_LDELIMIT & "1300" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "ABPEPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(7) = "ASPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
            Case "PRJ_AS"
                ao_grid.Title = "#AS Projects month view"
                
                ReDim la_Columns(8) As String
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "#Repl. days"
                la_Columns(2) = "ASProjects" & CH_LDELIMIT & "500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Projects" & CH_LDELIMIT & "#Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "Volume" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "#Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(4) = "TotalPrdVol" & CH_LDELIMIT & "1050" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(5) = "ABPEPrdVol" & CH_LDELIMIT & "950" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "ASPrdVol" & CH_LDELIMIT & "950" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(7) = "SOMVol" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SOMVol" & CH_LDELIMIT & "#Quoted vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(8) = "ProjectValue" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ProjectValue" & CH_LDELIMIT & "#Quoted value (EUR)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
        End Select
    Else
        Debug.Assert (as_period = "WEEK")
        Select Case as_prjType
            Case "PRJ_ALL"
                ao_grid.Title = "#All Projects week view"
                
                ReDim la_Columns(11) As String
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "350" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "Repl. days"
                la_Columns(2) = "STDProjects" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "STDProjects" & CH_LDELIMIT & "STD Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "SAProjects" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SAProjects" & CH_LDELIMIT & "SA Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(4) = "ASProjects" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASProjects" & CH_LDELIMIT & "AS Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(5) = "Volume" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "SolutionLine" & CH_LDELIMIT & "450" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SolutionLine" & CH_LDELIMIT & "Main solustion lines" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(7) = "TotalPrdVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(8) = "ABPEPrdVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(9) = "ASPrdVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(10) = "SOMVol" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SOMVol" & CH_LDELIMIT & "#Quoted vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(11) = "ProjectValue" & CH_LDELIMIT & "900" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ProjectValue" & CH_LDELIMIT & "#Quoted value (EUR)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
            Case "PRJ_STD"
                ao_grid.Title = "#Std Projects week view"
                
                ReDim la_Columns(7) As String
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "Repl. days"
                la_Columns(2) = "STDProjects" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "STDProjects" & CH_LDELIMIT & "STD Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "Volume" & CH_LDELIMIT & "1200" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(4) = "SolutionLine" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SolutionLine" & CH_LDELIMIT & "Main solustion lines" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(5) = "TotalPrdVol" & CH_LDELIMIT & "1300" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "ABPEPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(7) = "ASPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
            Case "PRJ_SA"
                ao_grid.Title = "#SA Projects week view"
                
                ReDim la_Columns(7) As String
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "Repl. days"
                la_Columns(2) = "SAProjects" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SAProjects" & CH_LDELIMIT & "SA Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "Volume" & CH_LDELIMIT & "1200" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(4) = "SolutionLine" & CH_LDELIMIT & "550" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SolutionLine" & CH_LDELIMIT & "Main solustion lines" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(5) = "TotalPrdVol" & CH_LDELIMIT & "1300" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "ABPEPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(7) = "ASPrdVol" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"

            Case "PRJ_AS"
                ao_grid.Title = "#AS Projects week view"
            
                ReDim la_Columns(8) As String
                
                la_Columns(0) = "GRP_DESC" & CH_LDELIMIT & "2500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "GRP_DESC" & CH_LDELIMIT & "GRP_DESC"
                la_Columns(1) = "REPLICS" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "REPLICS" & CH_LDELIMIT & "#Repl. days"
                la_Columns(2) = "ASProjects" & CH_LDELIMIT & "500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Projects" & CH_LDELIMIT & "#Prj. created" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0"
                la_Columns(3) = "Volume" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Volume" & CH_LDELIMIT & "#Prj. volume" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(4) = "TotalPrdVol" & CH_LDELIMIT & "1050" & CH_LDELIMIT & "0" & CH_LDELIMIT & "" & CH_LDELIMIT & "#Total vol. (SQM)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(5) = "ABPEPrdVol" & CH_LDELIMIT & "950" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ABPEPrdVol" & CH_LDELIMIT & "#ABPE vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(6) = "ASPrdVol" & CH_LDELIMIT & "990" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ASPrdVol" & CH_LDELIMIT & "#ABPE AS Dummy vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(7) = "SOMVol" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SOMVol" & CH_LDELIMIT & "#SOM vol." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
                la_Columns(8) = "ProjectValue" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ProjectValue" & CH_LDELIMIT & "#SOM value (EUR)" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "##,##0" & CH_LDELIMIT & "RIGHT"
        End Select
    
    End If
    
    Dim ls_Tag  As String
    ls_Tag = as_period & "_" & as_prjType
    Call ao_grid.SetColumns(la_Columns)
    
    ' translate
    If mo_Db.Find(mc_ScreenLabels, "FIELD_NAME", ls_Tag, , 1) >= 0 Then
      Call ao_grid.LoadConstants(ptStatic, mo_Db.GetFields(mc_ScreenLabels, "LOCAL_TEXT"), ctColumns)
    End If
    If mo_Db.Find(mc_ScreenLabels, "FIELD_NAME", ls_Tag & "_Title", , 1) >= 0 Then
      ao_grid.Title = mo_Db.GetFields(mc_ScreenLabels, "LOCAL_TEXT")
    End If
    
    Exit Sub
ErrorHandler:
    Call ErrorHandler(Me.Name & ".DefineProjectGrid")
End Sub


Private Sub grd_list_RowLoaded(ByVal al_Row As Long)
On Error GoTo ErrorHandler
    
    grd_list.Data(al_Row, "TotalPrdVol") = grd_list.Data(al_Row, "ABPEPrdVol") + grd_list.Data(al_Row, "ASPrdVol") + grd_list.Data(al_Row, "SOMVol")
    Exit Sub
    
ErrorHandler:
    Call ErrorMessage(Me.Name & ".grd_list_RowLoaded")

End Sub

Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    
    Call LockScreen(True)
    tlb_main.Enabled = False

    Select Case as_Role
        Case "L"
            ' display the detail
            If (chk_salesRep.value = vbUnchecked) And (chk_country.value = vbUnchecked Or (ml_cboTrw = ECapReportingTreeview.creArea Or ml_level_selected > 1)) Then
                MsgBox MsgText(1513, ms_Language_Code, "#Select grouping please.")
            Else
                Call LockScreen(False)
                Call Process_ProjectDetail(ml_Year, ml_Month, mb_top10, ms_prjType, ml_cboTrw, ms_period)
                Call LockScreen(True)
            End If
        Case "T"
            Me.Hide
    End Select
    
    tlb_main.Enabled = True
    
    Call LockScreen(False)
    Exit Sub

ErrHandler:
    tlb_main.Enabled = True
    Call LockScreen(False)
    
    Call LogMessage("tlb_Main_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
End Sub
